﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Diagnostics;

namespace CustomIndexers
{
    class Program
    {
        static void Main(string[] args)
        {
            // Listing 7-25. Stosowanie własnego indeksatora.
            Indexable ix = new Indexable();
            Console.WriteLine(ix[10]);
            ix[42] = "Xyzzy";


            ImmutableValue();
            MutableValue();

            MicroBenchmarkList();
        }

        static void ImmutableValue()
        {
            ArrayAndIndexer<int> aai = new ArrayAndIndexer<int>();
            aai.TheArray[10] = 42;
            Console.WriteLine(aai[10]);
            aai[20] = 99;
            Console.WriteLine(aai.TheArray[20]);
        }

        static void MutableValue()
        {
            ArrayAndIndexer<CanChange> aai = new ArrayAndIndexer<CanChange>();
            aai.TheArray[10] = new CanChange { Number = 42 };
            Console.WriteLine(aai[10].Number);
            aai[20] = new CanChange { Number = 99, Name = "Mój element" };
            Console.WriteLine(aai.TheArray[20].Number);

            aai.TheArray[10].Number = 123;
            Console.WriteLine(aai.TheArray[10].Number);

            // Tej instrukcji nie można skompilować.
            // Proszę usunąć komentarz by wyświetlić błąd.
            //aai[20].Number = 456;

            // Listing 7-27. Co mógł zrobić kompilator.
            CanChange elem = aai[20];
            elem.Number = 456;
        }


        static void MicroBenchmarkList()
        {
            // Listing 7-28. Mikropomiary wydajności list z elementami typów wartościowych i referencyjnych.
            // (Aby zmierzyć różnicę w wydajności działania klas i struktur należy zmienić
            // w definicji typu CanChange słowo kluczowe struct na class.)
            Stopwatch sw = new Stopwatch();
            sw.Start();
            int itemCount = 500000;
            List<CanChange> items = new List<CanChange>(itemCount);
            for (int i = 0; i < itemCount; ++i)
            {
                items.Add(new CanChange { Number = i });
            }
            sw.Stop();
            Console.WriteLine("Tworzenie: " + sw.ElapsedMilliseconds);
            sw.Reset();
            sw.Start();
            int total = 0;
            for (int i = 0; i < itemCount; ++i)
            {
                total += items[i].Number;
            }
            sw.Stop();
            Console.WriteLine("Suma wartości: " + total);
            Console.WriteLine("Sumaryczny czas: " + sw.ElapsedMilliseconds);
        }
    }
}
